package gov.vha.vuid.rest.data;

import java.util.Optional;

import org.jvnet.hk2.annotations.Contract;
import gov.vha.isaac.rest.api.data.vuid.RestVuidBlockData;
import gov.vha.isaac.rest.api.exceptions.RestException;

@Contract
public interface VuidService {

	/**
	 * Checks the database connection validity using a JDBC method without 
	 * running a query and checking the result.
	 * 
	 * @return true if the database connection is valid, false otherwise
	 */
	boolean isReady();
	
	/**
	 * Production mode is returning 'real' (positive) VUID values. It
	 * defaults to false, which will always return negative VUIDs.
	 * 
	 * @return true if using real VUIDs
	 */
	public boolean isProductionMode();
	
	/**
	 * The public method to request a single, or block of, VUIDs.
	 * 
	 * @param blocksize The number of VUIDs requested
	 * @param username The username of the requester
	 * @param reason The reason given for the request
	 * @return A RestVuidBlockData object with the block start and end values
	 */
	public RestVuidBlockData requestVuids(int blocksize, String username, String reason)
			throws RestException;
}
